/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.common.vo;

import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.MosPVo;
import jp.mosp.common.common.HtmlUtility;
import jp.mosp.common.common.MospException;
import jp.mosp.payroll.base.PayrollConst;
import jp.mosp.payroll.dto.MImportDto;
import jp.mosp.payroll.dto.MImportFieldDto;

public class ImportMasterCardVo extends MosPVo {

	private static final long serialVersionUID = 3108320215579078090L;

	// URLACSS
	private static final String RETURN_URL = "/jsp/payroll/common/importMasterCard.jsp";
	private static final String EXTRA_JS   = "/pub/payroll/common/js/importMasterCard.js";
	private static final String EXTRA_CSS  = "/pub/payroll/common/css/importMasterCard.css";

	// 萔
	public static final int MODE_INSERT = 0;
	public static final int MODE_UPDATE = 1;

	// p[^
	public static final String PRM_TXT_I_CODE		= "txtICode";
	public static final String PRM_TXT_I_NAME		= "txtIName";
	public static final String PRM_HID_I_TABLE	= "hidITable";
	public static final String PRM_HID_I_FIELD	= "pltIField";
	public static final String PRM_PLT_I_ORDER	= "pltIOrder";

	// tB[h
	private String		txtICode;
	private String		txtIName;
	private String		hidITable;
	private String		lblITable;
	private String[]	aryHidIField;
	private String[]	aryLblIField;
	private String[]	aryPltIOrder;

	// tB[hyѐ
	public static String NAM_I_CODE;
	public static String NAM_I_NAME;

	public static final int LEN_I_CODE = PayrollConst.LEN_I_CODE;
	public static final int LEN_I_NAME = PayrollConst.LEN_I_NAME;

	// v_EXg
	public String[][] aryPltOrder;
	public String[][] aryPltTable;

	// [h(0FVKo^A1FXV)
	private int mode;

	/**
	 * RXgN^
	 */
	public ImportMasterCardVo() {
		super();
		setRetUrl(RETURN_URL);
		addExtraJs(EXTRA_JS);
		setExtraCss(EXTRA_CSS);

		aryHidIField  = new String[0];
		aryLblIField  = new String[0];
		aryPltIOrder  = new String[0];
	
	}

	/**
	 * Tu^Cgݒ肷B
	 */
	@Override
	protected void setSubTitle() {
		super.setSubTitle();
		subTitle = getName("P_PAYMENT") + getName("P_IMPORT");
		aryMenu			= new String[2][2];
		aryMenu[0][0]	= "P1910";
		aryMenu[0][1]	= getName("C_MENU") + getName("C_TO");
		aryMenu[1][0]	= "P9022";
		aryMenu[1][1]	= getName("C_LIST") + getName("C_TO");
	}

	/**
	 * ږ̂ݒ肷B
	 */
	@Override
	protected void setFieldsName() {
		super.setFieldsName();
		NAM_I_CODE = getName("P_IMPORT") + getName("C_CODE");
		NAM_I_NAME = getName("P_IMPORT") + getName("P_MEISHOU");
	}

	/**
	 * p[^ݒ
	 * @param request NGXg
	 */
	@Override
	public void setParams(HttpServletRequest request) {
		txtICode		= request.getParameter(PRM_TXT_I_CODE);
		txtIName		= request.getParameter(PRM_TXT_I_NAME);
		hidITable		= request.getParameter(PRM_HID_I_TABLE);
		aryHidIField	= request.getParameterValues(PRM_HID_I_FIELD);
		aryPltIOrder	= request.getParameterValues(PRM_PLT_I_ORDER);
	}

	/**
	 * tB[hݒ
	 * @param dto
	 */
	public void setFields(MImportDto dto) {
		txtICode	= dto.getICode();
		txtIName	= dto.getIName();
		hidITable	= dto.getITable();
		lblITable	= getCodeName(dto.getITable(), aryPltTable);
	}

	/**
	 * tB[hݒ
	 * @param list
	 */
	public void setFields(List<MImportFieldDto> list) {
		Iterator it = list.iterator();
		while (it.hasNext()) {
			MImportFieldDto dto = (MImportFieldDto)it.next();
			for (int i = 0; i < aryHidIField.length; i++) {
				if (dto.getIField().equals(aryHidIField[i])) {
					aryPltIOrder[i] = String.valueOf(dto.getIOrder());
					break;
				}
			}
		}
	}

	/**
	 * tB[hݒ(DTOɑ΂VÕZbg)
	 * @param dto ݒΏDTO
	 */
	public void setDtoFields(MImportDto dto) {
		dto.setICode(txtICode);
		dto.setIName(txtIName);
		dto.setITable(hidITable);
	}

	/**
	 * tB[hݒ(DTOɑ΂VÕZbg)
	 * @param dto ݒΏDTO
	 * @param i
	 */
	public void setDtoFields(MImportFieldDto dto, int i) {
		dto.setICode(txtICode);
		dto.setIField(aryHidIField[i]);
		dto.setIOrder(getIntParam(aryPltIOrder[i]));
	}

	/**
	 * tB[h̑ÓmF
	 * @throws MospException
	 */
	public void validate() throws MospException {
		// ÓmFJn
		startValidation();
		// K{mF
		checkRequired(txtICode	, NAM_I_CODE	, PRM_TXT_I_CODE);
		checkRequired(txtIName	, NAM_I_NAME	, PRM_TXT_I_NAME);
		// 񒷊mF
		checkLength(txtICode, LEN_I_CODE, NAM_I_CODE, PRM_TXT_I_CODE);
		checkLength(txtIName, LEN_I_NAME, NAM_I_NAME, PRM_TXT_I_NAME);
		// ÓmFI
		endValidation();
	}

	/**
	 * JavaScriptݒ
	 * @param cls 擾NX
	 * @throws IllegalAccessException
	 */
	@Override
	public String getDirectJs(Class cls) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls));
		sb.append("var MODE = ");
		sb.append(mode);
		sb.append(";");
		sb.append("var NAM_I_ORDER = new Array(");
		for (int i = 0; i < aryLblIField.length; i++) {
			sb.append("\"");
			sb.append(aryLblIField[i]);
			sb.append("\", ");
		}
		sb.delete(sb.length() - 2, sb.length());
		sb.append(");");
		return sb.toString();
	}

	// ANZT\bh
	public String[] getAryHidIField() { return aryHidIField.clone(); }
	public String[] getAryLblIField() { return aryLblIField.clone(); }
	public String[] getAryPltIOrder() { return aryPltIOrder.clone(); }

	public String getTxtICode	() { return txtICode	; }
	public String getTxtIName	() { return txtIName	; }
	public String getHidITable	() { return hidITable	; }
	public String getLblITable	() { return lblITable	; }

	public String getEscTxtICode	() { return escapeHTML(txtICode)	; }
	public String getEscTxtIName	() { return escapeHTML(txtIName)	; }
	public String getEscHidITable	() { return escapeHTML(hidITable)	; }
	public String getEscLblITable	() { return escapeHTML(lblITable)	; }

	public void setAryHidIField(String[] aryHidIField) { this.aryHidIField = aryHidIField.clone(); }
	public void setAryLblIField(String[] aryLblIField) { this.aryLblIField = aryLblIField.clone(); }
	public void setAryPltIOrder(String[] aryPltIOrder) { this.aryPltIOrder = aryPltIOrder.clone(); }

	public void setTxtICode	(String txtICode	) { this.txtICode	= txtICode	; }
	public void setTxtIName	(String txtIName	) { this.txtIName	= txtIName	; }
	public void setHidITable	(String hidITable	) { this.hidITable	= hidITable	; }
	public void setLblITable	(String lblITable	) { this.lblITable	= lblITable	; }

	public void	setMode(int mode)	{ this.mode = mode; }
	public int		getMode()			{ return mode; }	

	/**
	 * K{}[NóB
	 * @param fieldCode tB[hR[h
	 * @return HTMLK{}[N
	 */
	public String getRequiredMark(String fieldCode) {
		String retStr = "";
		if (fieldCode.equals(PayrollConst.CODE_IMPORT_FIELD_KCODE)
				|| fieldCode.equals(PayrollConst.CODE_IMPORT_FIELD_SIMEI)
				|| fieldCode.equals(PayrollConst.CODE_IMPORT_FIELD_FURIGANA)
				|| fieldCode.equals(PayrollConst.CODE_IMPORT_FIELD_SCODE)
				|| fieldCode.equals(PayrollConst.CODE_IMPORT_FIELD_YCODE)
				|| fieldCode.equals(PayrollConst.CODE_IMPORT_FIELD_TOKYU)
				|| fieldCode.equals(PayrollConst.CODE_IMPORT_FIELD_JCODE)
				|| fieldCode.equals(PayrollConst.CODE_IMPORT_FIELD_NYDATE)
				|| fieldCode.equals(PayrollConst.CODE_IMPORT_FIELD_KNKUBUN)
				|| fieldCode.equals(PayrollConst.CODE_IMPORT_FIELD_HIZUKE)
				|| fieldCode.equals(PayrollConst.CODE_IMPORT_FIELD_SYJIKOKU)
				|| fieldCode.equals(PayrollConst.CODE_IMPORT_FIELD_KINMU)
				|| fieldCode.equals(PayrollConst.CODE_IMPORT_FIELD_TAJIKOKU)
				|| fieldCode.equals(PayrollConst.DTL_SNEN )
				|| fieldCode.equals(PayrollConst.DTL_STUKI )
				|| fieldCode.equals(PayrollConst.DTL_SHI )
				|| fieldCode.equals(PayrollConst.DTL_SNISSU)
				|| fieldCode.equals(PayrollConst.DTL_SKAISU)
				|| fieldCode.equals(PayrollConst.DTL_KINMUJI)
				|| fieldCode.equals(PayrollConst.DTL_ZAJIKAN)
				|| fieldCode.equals(PayrollConst.DTL_SNJIKAN)
				|| fieldCode.equals(PayrollConst.DTL_KSJIKAN)
				|| fieldCode.equals(PayrollConst.DTL_KYUKEIJI)
		) {
			retStr = HtmlUtility.getRequiredMark();
		}
		return retStr;
	}

}
